/*****************************************************************************/

//  CREATED BY SILVIU-MARIUS ARDELEAN   
//  COPYRIGHT BY SILVIU-MARIUS ARDELEAN
//  http://silviuardelean.ro
//  PUBLISH DATE: 2011.01.15
//  REVISION 1.0
//
//	THIS SOFTWARE AND THE ACCOMPANYING FILES ARE DISTRIBUTED "AS IS" AND WITHOUT
//	ANY WARRANTIES WHETHER EXPRESSED OR IMPLIED. NO REPONSIBILITIES FOR POSSIBLE
//	DAMAGES OR EVEN FUNCTIONALITY CAN BE TAKEN. THE USER MUST ASSUME THE ENTIRE
//	RISK OF USING THIS SOFTWARE.
//
//  YOU CAN FREELY USE THIS CLASS AND PERFORM MODIFICATIONS TO IT, AS LONG AS YOU DO NOT REMOVE THIS HEADER!
//
//  LICENSE: Creative Commons Attribution (cc by) (http://creativecommons.org/about/licenses/)

/******************************************************************************/


#pragma once
#include <sstream>
#include <string>
#include <stdexcept>

#ifdef _UNICODE
	#define xstring			std::wstring
	#define	xostringstream	std::wostringstream
	#define	xistringstream	std::wistringstream
#else
	#define xstring std::string
	#define	xostringstream	std::ostringstream
	#define	xistringstream	std::istringstream
#endif

class BadConversion : public std::runtime_error {
public:
	BadConversion(const std::string& s)
		: std::runtime_error(s)
	{ }
};

class String2Numeric
{
  public:

	template <class TypeT>
	static xstring Type2String(TypeT x) 
	{
		xostringstream o;
		if (!(o << x))
			throw BadConversion("Type2String(TypeT)");

		return o.str();
	} 

	template <class TypeT>
	static TypeT   String2Type(const xstring& s)
	{
		xistringstream i(s);
		TypeT x;
		if (!(i >> x))
			throw BadConversion("String2Type(TypeT)");

		return x;
	}
};
