// it.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <string>
#include <list>
#include "windows.h"
#include <vector>
#include <map>

using namespace std;

struct custom_t
{
	int a;
	float b;
	char c;
};

int _tmain(int argc, _TCHAR* argv[])
{
	__int64 ctr1 = 0, ctr2 = 0, freq = 0;
	double res[20];


	QueryPerformanceFrequency((LARGE_INTEGER *)&freq);

	vector<custom_t> vcustom;
	list<custom_t> lcustom;
	map<int, custom_t> mcustom;

	for (unsigned int x = 0; x < 10000000;x++)
	{
		custom_t xx;
		vcustom.push_back(xx);
		lcustom.push_back(xx);
		mcustom[x] = xx;
	}

	// vector
	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (vector<custom_t>::iterator i = vcustom.begin(); i != vcustom.end();++i)
		{
			(*i).a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	double fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG vector<custom_t> ++it Time: %f\n", fin);

	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (vector<custom_t>::iterator i = vcustom.begin(); i != vcustom.end();i++)
		{
			(*i).a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG vector<custom_t> it++ Time: %f\n", fin);

	// list
	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (list<custom_t>::iterator i = lcustom.begin(); i != lcustom.end();++i)
		{
			(*i).a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG list<custom_t> ++it Time: %f\n", fin);


	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (list<custom_t>::iterator i = lcustom.begin(); i != lcustom.end();i++)
		{
			(*i).a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG list<custom_t> it++ Time: %f\n", fin);

	// map
	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (map<int, custom_t>::iterator i = mcustom.begin(); i != mcustom.end();++i)
		{
			(*i).second.a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG map<int, custom_t> ++it Time: %f\n", fin);

	for (int k=0; k<20; ++k)
	{
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr1);

		for (map<int, custom_t>::iterator i = mcustom.begin(); i != mcustom.end();i++)
		{
			(*i).second.a++;
		}
		QueryPerformanceCounter((LARGE_INTEGER *)&ctr2);
		res[k] = (ctr2 - ctr1) * 1.0 / freq;
	}

	fin = 0.0;
	for (int i=0; i<20; ++i)
		fin += res[i];

	fin /= 20.0;
	printf(">>> AVG map<int, custom_t> i++ Time: %f\n", fin);

	return 0;
}