#include <windows.h>

class Timing {
public:
	Timing() :
	   value(0)
	 , oldmask(0)
	{
		QueryPerformanceFrequency(&performance_frequency);
	}

    void Timing::StartTiming()
	{         
		  oldmask = SetThreadAffinityMask(::GetCurrentThread(), 1);

		  volatile size_t warmingUp = 1;
		  for (size_t i=1; i<100000; i++)
				warmingUp *= i;

		  QueryPerformanceCounter(&time1);
	}  

	void StopTiming()
	{  
	  LARGE_INTEGER time2;
	  QueryPerformanceCounter(&time2);  
	  SetThreadAffinityMask(::GetCurrentThread(), oldmask);

	  value = (double)(time2.QuadPart - time1.QuadPart);
	  value /= performance_frequency.QuadPart;
	} 

    double GetUserSeconds() const {    return value;  }

private:
  DWORD_PTR oldmask;
  double value;
  LARGE_INTEGER time1;
  LARGE_INTEGER performance_frequency;
};