// preVSpost.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream>
#include <tchar.h>
#include <assert.h>
#include <string>
#include <vector>
#include <list>
#include <map>
#include <unordered_map>
#include <ppl.h>
#include "timing.h"
#include <random>
#include <fstream>
#include <time.h>

using namespace  std;
using namespace  Concurrency;

typedef struct results {
	double vector_time_pre;
	double vector_time_post;
	double list_time_pre;
	double list_time_post;
	double map_time_pre;
	double map_time_post;
	double unordered_map_time_pre;
	double unordered_map_time_post;
} RESULTS;

template <class T>
size_t FooPre(const T &arr)
{
  size_t sum = 0;
  
  for (auto it = arr.begin(); it != arr.end(); ++it)
    sum += *it;

  return sum;
}

template <class T>
size_t FooPost(const T &arr)
{
  size_t sum = 0;
  
  for (auto it = arr.begin(); it != arr.end(); it++)
    sum += *it;

  return sum;
}

template <class T>
size_t FooMapPre(const T &arr)
{
  size_t sum = 0;
  
  for (auto it = arr.begin(); it != arr.end(); ++it)
    sum += it->second;

  return sum;
}

template <class T>
size_t FooMapPost(const T &arr)
{
  size_t sum = 0;
  
  for (auto it = arr.begin(); it != arr.end(); it++)
    sum += it->second;

  return sum;
}

void SerialComputation(const long& Count, const vector<size_t>& arr, const list<size_t>& lst, const map<size_t,size_t>& m, 
									const unordered_map<size_t, size_t>& um, vector<RESULTS>&	vResults)
{
	RESULTS res;
	Timing  metric;

	cout << "Single core" << endl;
	cout << "-----------------------------------------------" << endl;

	// vector
    long long x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
	    x += FooPre(arr);
    metric.StopTiming();
	res.vector_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
    cout << "vector::++iterator. Total time : " << res.vector_time_pre << endl;
	

    x = 0; 
   metric.StartTiming();
   for (size_t i = 0; i != Count; ++i)
   {
      x += FooPost(arr);
	}
    metric.StopTiming();
	res.vector_time_post = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
    cout << "vector::iterator++. Total time : " << res.vector_time_post << endl;

	cout << "==============================================" << endl;

	// list
    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
      x += FooPre(lst);
    metric.StopTiming();
	res.list_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
	cout << "list::++iterator. Total time : " << res.list_time_pre << endl;
    

    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
	    x += FooPost(lst);
    metric.StopTiming();
	res.list_time_post	= metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
    cout << "list::iterator++. Total time : " << res.list_time_post << endl;

	cout << "==============================================" << endl;

	// map
    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
      x += FooMapPre(m);
    metric.StopTiming();
	res.map_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
	cout << "map::++iterator. Total time : " << res.map_time_pre << endl;

    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
	    x += FooMapPost(m);
    metric.StopTiming();
	res.map_time_post = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
	cout << "map::iterator++. Total time : " << res.map_time_post << endl;

	cout << "==============================================" << endl;

	// unordered_map
    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
      x += FooMapPre(um);
    metric.StopTiming();
	res.unordered_map_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
    cout << "unordered_map::++iterator. Total time : " << res.unordered_map_time_pre << endl;

    x = 0;
    metric.StartTiming();
	  for (size_t i = 0; i != Count; ++i)
	    x += FooMapPost(um);
    metric.StopTiming();
	res.unordered_map_time_post = metric.GetUserSeconds();
    cout << "Sum = " << x << endl;
	cout << "unordered_map::iterator++. Total time : " << res.unordered_map_time_post << endl;

	vResults.push_back(res);
}


void ParallelComputation(const size_t& Count, const vector<size_t>& arr, const list<size_t>& lst, const map<size_t,size_t>& m, 
									const unordered_map<size_t, size_t>& um, vector<RESULTS>&	vResults)
{
	RESULTS res;
	Timing  metric;
	combinable<int> cnt([]() { return 0; });     

	cout << "-----------------------------------------------" << endl;
	cout << endl << "Multi Core" << endl;
	cout << "-----------------------------------------------" << endl;
	
	// vector
    metric.StartTiming();
		parallel_for (size_t(0), Count,  
		[&cnt,&arr](size_t i) {
			cnt.local() += FooPre(arr);
		});
    metric.StopTiming();
	res.vector_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
    cout << "vector::++iterator. Total time : " << res.vector_time_pre << endl;

	cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		[&cnt,&arr](size_t i) {
			cnt.local() += FooPost(arr);
		 });
    metric.StopTiming();
	res.vector_time_post = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
    cout << "vector::iterator++. Total time : " << res.vector_time_post << endl;

	cout << "==============================================" << endl;

	// list
    cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		[&cnt,&lst](size_t i) {
			cnt.local() += FooPre(lst);
		 });
    metric.StopTiming();
	res.list_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
	cout << "list::++iterator. Total time : " << res.list_time_pre << endl;
    
    cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		[&cnt,&lst](size_t i) {
			cnt.local() += FooPost(lst);
	    });
    metric.StopTiming();
	res.list_time_post = metric.GetUserSeconds();
	cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
    cout << "list::iterator++. Total time : " << res.list_time_post << endl;

	cout << "==============================================" << endl;

	// map
    cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		  [&cnt,&m](size_t i) {
			cnt.local() += FooMapPre(m);
		  });
    metric.StopTiming();
	res.map_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
	cout << "map::++iterator. Total time : " << res.map_time_pre << endl;

    cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		[&cnt,&m](size_t i) {
	      cnt.local() += FooMapPost(m);
		});
    metric.StopTiming();
	res.map_time_post = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
	cout << "map::iterator++. Total time : " << res.map_time_post << endl;

	cout << "==============================================" << endl;

	// unordered_map
	cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
	    [&cnt,&um](size_t i) {
		  cnt.local() += FooMapPre(um);
	     });
    metric.StopTiming();
	res.unordered_map_time_pre = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
    cout << "unordered_map::++iterator. Total time : " << res.unordered_map_time_pre << endl;

    cnt.clear();
    metric.StartTiming();
	  parallel_for (size_t(0), Count,  
		[&cnt,&um](size_t i) {
			cnt.local() += FooMapPost(um);
		});
    metric.StopTiming();
	res.unordered_map_time_post = metric.GetUserSeconds();
    cout << "Sum = " << cnt.combine(plus<size_t>()) << endl;
	cout << "unordered_map::iterator++. Total time : " << res.unordered_map_time_post << endl;

	vResults.push_back(res);
}

int _tmain(int argc, _TCHAR* argv[])
{
	vector<size_t>					arr;
	list<size_t>					lst;
	map<size_t, size_t>				m;
	unordered_map<size_t, size_t>	um;
	vector<RESULTS>					vResSerial, vResParallel;

	minstd_rand   gen;
	gen.seed((unsigned int)time(NULL));

	unsigned int randNo = 0;
    for (size_t i = 0; i != 99999; ++i)
	{
	  randNo = gen() % 15;  // limit in order to avoid sums overflow

      arr.push_back(randNo);
	  lst.push_back(randNo);
	  m.insert(pair<size_t, size_t>(i, randNo));
	  um.insert(pair<size_t, size_t>(i, randNo));
	}

	 const size_t Count = 300, rep = 10;

	 for (int i = 0; i < rep; ++i)
	 {
		cout << "\nIteration no.: " << i+1 << endl << endl;
		SerialComputation(Count, arr, lst, m, um, vResSerial);
	 }

    ofstream fileSerial("benchmark - serial.txt", ios_base::out | ios_base::trunc);
	if (fileSerial.is_open())
	{
		for (auto it = vResSerial.begin(); it != vResSerial.end(); ++it)
		{
			fileSerial << it->vector_time_pre << "\t" << it->vector_time_post << "\t" <<
						  it->list_time_pre << "\t" << it->list_time_post << "\t" <<
						  it->map_time_pre << "\t" << it->map_time_post << "\t" <<
						  it->unordered_map_time_pre << "\t" << it->unordered_map_time_post << endl;
		}

		fileSerial.close(); // not absolutely needed 
	}


	for (int i = 0; i < rep; ++i)
	{
	     cout << "\nIteration no.: " << i+1 << endl << endl;
		 ParallelComputation(Count, arr, lst, m, um, vResParallel);
	}

	ofstream fileParallel("benchmark - parallel.txt", ios_base::out | ios_base::trunc);
	if (fileParallel.is_open())
	{
		for (auto it = vResParallel.begin(); it != vResParallel.end(); ++it)
		{
			fileParallel << it->vector_time_pre << "\t" << it->vector_time_post << "\t" <<
						    it->list_time_pre << "\t" << it->list_time_post << "\t" <<
						    it->map_time_pre << "\t" << it->map_time_post << "\t" <<
							it->unordered_map_time_pre << "\t" << it->unordered_map_time_post << endl;
		} 

		fileParallel.close();
	}

	return 0;
}