// MDIClientWnd.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "testBackground2010.h"
#include "MDIClientWnd.h"


// CMDIClientWnd

IMPLEMENT_DYNAMIC(CMDIClientWnd, CWnd)

CMDIClientWnd::CMDIClientWnd()
{

}

CMDIClientWnd::~CMDIClientWnd()
{
}


BEGIN_MESSAGE_MAP(CMDIClientWnd, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_SIZE()
END_MESSAGE_MAP()



// CMDIClientWnd message handlers




BOOL CMDIClientWnd::OnEraseBkgnd(CDC* pDC)
{
   return FALSE;
}

void CMDIClientWnd::OnPaint()
{
   CPaintDC dc(this); // device context for painting
	
   CRect rcClient;
   GetClientRect(rcClient);

   CDC dcMem1; // memory DC for double buffering
   dcMem1.CreateCompatibleDC(&dc);
   CBitmap bitmap1;
   bitmap1.CreateCompatibleBitmap(&dc, rcClient.Width(), rcClient.Height());
   CBitmap* pOldBitmap1 = dcMem1.SelectObject(&bitmap1);
   // fill memory device context with the desired brush
   // COLOR_APPWORKSPACE is for default MDI client color
   CBrush backBrush;
   backBrush.CreateSolidBrush(::GetSysColor(COLOR_APPWORKSPACE));
   dcMem1.FillRect(rcClient, &backBrush);

   CDC dcMem2; // memory DC for the bitmap to draw
   dcMem2.CreateCompatibleDC(&dc);
   CBitmap bitmap2;
   bitmap2.LoadBitmap(IDB_LOGO);
   CBitmap* pOldBitmap2 = dcMem2.SelectObject(&bitmap2);

   BITMAP bmp;
   bitmap2.GetBitmap(&bmp);
   int nWidth  = bmp.bmWidth;
   int nHeight = bmp.bmHeight;

   int x       = rcClient.right / 2 - nWidth / 2;
   int y       = rcClient.bottom / 2 - nHeight /2;
   // copy the bitmap in memory device context 
   dcMem1.BitBlt(x, y, nWidth, nHeight, &dcMem2, 0, 0, SRCCOPY);

   CRect rcClip;
   dc.GetClipBox(rcClip);

   nWidth  = rcClip.Width();
   nHeight = rcClip.Height();
   x       = rcClip.left;
   y       = rcClip.top;
   // copy memory device context in client device context
   dc.BitBlt(x, y, nWidth, nHeight, &dcMem1, x, y, SRCCOPY); 

   dcMem1.SelectObject(pOldBitmap1);
   dcMem2.SelectObject(pOldBitmap2);
}

