#include "stdafx.h"
#include "htmlGen.h"


CHTMLGen::CHTMLGen(void)
{
}

CHTMLGen::~CHTMLGen(void)
{
}

bool CHTMLGen::Generate(const std::wstring &sXmlFile, const std::wstring &sXsltFile, const std::wstring &sHTMLFile)
{
   if (!PathFileExists(sXmlFile.c_str()) || !PathFileExists(sXsltFile.c_str())) {
      return false;
   }

   HRESULT  hr;
   CComPtr<IXMLDOMDocument>  pXml, pXslt;

   hr = CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER, 
                           IID_IXMLDOMDocument, (void**)&pXml);
   if (FAILED(hr)) 
      return false;

   VARIANT_BOOL   bOkLoad;
   CComVariant    varFile;

   varFile = sXmlFile.c_str();
   pXml->put_async(VARIANT_FALSE);
   hr = pXml->load(varFile, &bOkLoad);
   if (FAILED(hr) && (bOkLoad == VARIANT_FALSE))
      return false;

   hr = CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER,
                           IID_IXMLDOMDocument, (void**)&pXslt);
   if (FAILED(hr))
      return false;

   varFile = sXsltFile.c_str();
   pXslt->put_async(VARIANT_FALSE);
   hr = pXslt->load(varFile, &bOkLoad);
   if (FAILED(hr) && (bOkLoad == VARIANT_FALSE))
      return false;

	CComBSTR bsHtmlRes;
    std::wstring sHTMLRes = _T("");
	hr = pXml->transformNode(pXslt, &bsHtmlRes);
	if(SUCCEEDED(hr))
	{
		CAtlString sRes(bsHtmlRes);
		if(!_tcsnicmp(sRes, _T("<?xml"), 5))
		{
			TCHAR *szEnd = _tcsstr(sRes.GetBuffer(), _T("?>"));
			sHTMLRes += szEnd ? (szEnd + 2) : sRes;
		}
		else
			sHTMLRes += sRes;
	}
	
	return (_T("") != sHTMLRes) ? SaveFileContent(sHTMLFile, sHTMLRes) : false;
}

bool CHTMLGen::SaveFileContent(const std::wstring& sFileName, const std::wstring& sFileContent)
{
   FILE *pFile = NULL; 
   _wfopen_s(&pFile, sFileName.c_str(), _T("w, ccs=utf-8"));
   if(!pFile)
      return false;

   int ret = fputws(sFileContent.c_str(), pFile);
   fclose(pFile);

   return (WEOF != ret);
}